*     *****************************************************************   *;
*     *****************************************************************   *;
*   File-Name:     cops.do     				    				          *;
*   Date:          June 7, 2021                                  	      *;
*   Author:        Lisa Dellmuth	   							          *;
*   Input File:    cops.dta		 				                          *; 
*   Related paper: Non-state actor perceptions of legitimacy and		  *; 
*   meaningful participation in international climate governance 		  *;
*     ****************************************************************    *;
*     ****************************************************************    *;

* Stata/IC 
vers 18.5

* open data
use cops.dta

* recode
encode constituency, gen(numconstituency) 
gen constgroup=.
replace constgroup=1 if numconstituency==1
replace constgroup=2 if numconstituency==3|numconstituency==4|numconstituency==8|numconstituency==9|numconstituency==10
replace constgroup=3 if numconstituency==2
replace constgroup=4 if numconstituency==7
label define constgroup 1 "Business" 2 "CSOs" 3 "ENGOs" 4 "Research", modify
label values constgroup constgroup

label define conf 0 "None at all" 1 "Not very much" 2 "Quite a lot" 3 "A great deal", modify
encode conf_adapt, gen(numconfunfcccadapt) 
recode numconfunfcccadapt 1=3 2=. 3=0 4=1 5=2 
label values numconfunfcccadapt conf 

encode conf_mit, gen(numconfunfcccmit) 
recode numconfunfcccmit 1=3 2=. 3=0 4=1 5=2 
label values numconfunfcccmit conf 

encode conf_natgov, gen(numconfnatgov)
recode numconfnatgov 1=3 2=. 3=0 4=1 5=2 
label values numconfnatgov conf

encode conf_localgov, gen(numconflocalgov)
recode numconflocalgov 1=3 2=. 3=0 4=1 5=2 
label values numconflocalgov conf

label define participation 0 "Not at all" 1 "Somewhat" 2 "To a great extent" 3 "Very little", modify
encode part_meaningful_adapt, gen(numpart_meaningful_adapt)
recode numpart_meaningful_adapt 1=. 2=0 3=1 4=3 5=2
label values numpart_meaningful_adapt participation

encode part_meaningful_mit, gen(numpart_meaningful_mit)
recode numpart_meaningful_mit 1=. 2=0 3=1 4=3 5=2
label values numpart_meaningful_mit participation


* analysis: t-tests

gen copdum=.
replace copdum=0 if cop==26
replace copdum=1 if cop==27
ttest numconfunfcccadapt, by(copdum)
ttest numconfunfcccmit, by(copdum)
ttest numconfnatgov, by(copdum)
ttest numconflocalgov, by(copdum)
ttest numpart_meaningful_adapt, by(copdum)
ttest numpart_meaningful_mit, by(copdum)

ttest numconfunfcccadapt = numconfunfcccmit
ttest numconfunfcccadapt = numconfnatgov
ttest numconfunfcccadapt = numconflocalgov
ttest numconfnatgov = numconflocalgov

tab constgroup // 1 business, 2 CSOs, 3 ENGOs, 4 research
tab constgroup, gen(g) 
ttest numconfunfcccadapt if constgroup==1|constgroup==2, by(g1)
ttest numconfunfcccadapt if constgroup==1|constgroup==3, by(g1)
ttest numconfunfcccadapt if constgroup==1|constgroup==4, by(g1)
ttest numconfunfcccadapt if constgroup==2|constgroup==3, by(g2)
ttest numconfunfcccadapt if constgroup==2|constgroup==4, by(g2)
ttest numconfunfcccadapt if constgroup==3|constgroup==4, by(g3)
ttest numconfunfcccadapt, by(g4)

ttest numconfunfcccmit if constgroup==1|constgroup==2, by(g1)
ttest numconfunfcccmit if constgroup==1|constgroup==3, by(g1)
ttest numconfunfcccmit if constgroup==1|constgroup==4, by(g1)
ttest numconfunfcccmit if constgroup==2|constgroup==3, by(g2)
ttest numconfunfcccmit if constgroup==2|constgroup==4, by(g2)
ttest numconfunfcccadapt if constgroup==3|constgroup==4, by(g3)
ttest numconfunfcccmit, by(g4)

ttest numpart_meaningful_adapt if constgroup==1|constgroup==2, by(g1)
ttest numpart_meaningful_adapt if constgroup==1|constgroup==3, by(g1)
ttest numpart_meaningful_adapt if constgroup==1|constgroup==4, by(g1)
ttest numpart_meaningful_adapt if constgroup==2|constgroup==3, by(g2)
ttest numpart_meaningful_adapt if constgroup==2|constgroup==4, by(g2)
ttest numpart_meaningful_adapt if constgroup==3|constgroup==4, by(g3)
ttest numpart_meaningful_adapt, by(g4)

ttest numpart_meaningful_mit if constgroup==1|constgroup==2, by(g1)
ttest numpart_meaningful_mit if constgroup==1|constgroup==3, by(g1)
ttest numpart_meaningful_mit if constgroup==1|constgroup==4, by(g1)
ttest numpart_meaningful_mit if constgroup==2|constgroup==3, by(g2)
ttest numpart_meaningful_mit if constgroup==2|constgroup==4, by(g2)
ttest numpart_meaningful_mit if constgroup==3|constgroup==4, by(g3)
ttest numpart_meaningful_mit, by(g4)


*analysis: figure 1
grstyle clear
set scheme plotplain
grstyle init
grstyle set plain, box
grstyle color background white 
grstyle yesno draw_major_hgrid yes
grstyle yesno draw_major_ygrid yes
grstyle color major_grid gs8
grstyle linepattern major_grid dot
grstyle set legend 2, box inside
grstyle color ci_area gs12%50

preserve
gen ad=.
replace ad=0 if numconfunfcccadapt==0|numconfunfcccadapt==1
replace ad=1 if numconfunfcccadapt==2|numconfunfcccadapt==3 
gen mit=.
replace mit=0 if numconfunfcccmit==0|numconfunfcccmit==1
replace mit=1 if numconfunfcccmit==2|numconfunfcccmit==3
gen nat=. 
replace nat=0 if numconfnatgov==0|numconfnatgov==1
replace nat=1 if numconfnatgov==2|numconfnatgov==3
gen loc=.
replace loc=0 if numconflocalgov==0|numconflocalgov==1
replace loc=1 if numconflocalgov==2|numconflocalgov==3
tab ad 
tab mit
tab nat
tab loc
collapse ad mit nat loc
graph bar  mit ad  loc nat,  ytitle(% quite a lot or a great deal of confidence) ylabel(0 "0%" .2 "20%" .4 "40%" .6 "60%" .8 "80%" 1 "100%", /// 
labsize(small) labcolor(black) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) 
saving(fig1.gph) 


*analysis: figure 2
preserve
gen ad=.
replace ad=0 if numconfunfcccadapt==0|numconfunfcccadapt==1
replace ad=1 if numconfunfcccadapt==2|numconfunfcccadapt==3 
gen mit=.
replace mit=0 if numconfunfcccmit==0|numconfunfcccmit==1
replace mit=1 if numconfunfcccmit==2|numconfunfcccmit==3  
collapse ad mit , by(constgroup) 
graph bar ad mit , over(const)  ytitle(% quite a lot or a great deal of confidence)  ylabel(0 "0%" .2 "20%" .4 "40%" .6 "60%" .8 "80%" 1 "100%", /// 
labsize(small) labcolor(black) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2))  
saving(fig2.gph) 


*analysis: figure 3 
preserve 
gen ad=.
replace ad=0 if numpart_meaningful_adapt==0|numpart_meaningful_adapt==1
replace ad=1 if numpart_meaningful_adapt==2|numpart_meaningful_adapt==3
gen mit=.
replace mit=0 if numpart_meaningful_mit==0|numpart_meaningful_mit==1
replace mit=1 if numpart_meaningful_mit==2|numpart_meaningful_mit==3 
collapse ad mit, by(constgroup)
graph bar ad mit, over(const)   ytitle(% meaningful participation somewhat or to a great extent) ylabel(0 "0%" .2 "20%" .4 "40%" .6 "60%" .8 "80%" 1 "100%", /// 
labsize(small) labcolor(black) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2))  
saving(fig3.gph) 


* By experience

tab cops_attended

preserve
recode cops_attended 1/25=1
ttest numconfunfcccadapt, by(cops_attended)
ttest numconfunfcccmit, by(cops_attended)
ttest numpart_meaningful_mit, by(cops_attended) 
ttest numpart_meaningful_adapt, by(cops_attended) 

preserve
recode cops_attended 0/1=1 2/25=2
ttest numconfunfcccadapt, by(cops_attended)
ttest numconfunfcccmit, by(cops_attended)
ttest numpart_meaningful_mit, by(cops_attended) 
ttest numpart_meaningful_adapt, by(cops_attended) 

preserve
recode cops_attended 0/2=1 3/25=2
ttest numconfunfcccadapt, by(cops_attended)
ttest numconfunfcccmit, by(cops_attended)
ttest numpart_meaningful_mit, by(cops_attended) 
ttest numpart_meaningful_adapt, by(cops_attended) 

sort conf_adapt
ed constgroup conf_adapt
sort conf_mit
ed constgroup conf_mit
sort part_meaningful_mit
ed constgroup part_meaningful_mit
sort part_meaningful_adapt
ed constgroup part_meaningful_adapt
ed constgroup conf_mit
corr constgroup numconfunfcccadapt 
corr constgroup numpart_meaningful_adapt 
tab conf_adapt
tab numconfunfcccadapt
tab conf_mit
tab numconfunfcccmit
tab numpart_meaningful_mit
tab numpart_meaningful_adapt
tab constituency

by constgroup, sort: sum numconfunfcccadapt numconfunfcccmit  numpart_meaningful_adapt numpart_meaningful_mit





